



# 概述
### 通信流程
相对usb 64byte传输，json格式命令数据长度大多都是比较长的。使用常规的一问一答的方式效率较低；
所以设计了如下通信方式：

- STEP 1，发送包头数据信息 ==》 发送纯数据 ==》 发送询问
- STEP 2，接收方回复：
 - 正确->本次通信结束; ==》 后续接收方附加信息可以在ACK之后紧跟回复。再进step1
 - 错误->回复丢失包 进入step3
- STEP 3，发送方法发送丢数据 ==》 发送询问 进入step2

### 说明：
- 为了避免通信失败时重发的代价太大，在step 1中将数据包拆分成N个以1024bytes为单位的小数据包；
当如上传输出错时，只需重传当前的1024bytes即可;
- 为了解决通信双方随时都可以主动发起，通信双方在所有数据头上加上明显辨识，用于接收方识别收到的数据是对方主动发送还是ack;

如下是基站主动发送的数据头
| **基站发送数据头** | **描述** | **sdk回复数据头** |
| --- | --- | --- |
| 0xB1 | 基站主动发送数据信息 | 0xB1 |
| 0xB2  | 基站主动发送纯数据 | 无需回复 |
| 0xB3 | 基站主动发送询问 | 0xB3 |

如下是SDK主动发送的数据头
| **SDK发送数据头** | **描述** | **基站回复数据头** |
| --- | --- | --- |
| 0xD1 | SDK主动发送数据信息 | 0xD1 |
| 0xD2  | SDK主动发送纯数据 | 无需回复 |
| 0xD3 | SDK主动发送询问 | 0xD3 |



# 一， 协议描述


## 1.1 发送数据信息
发送方发送数据：(所有非1字节数据都是高字节在前)
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 0 | Header | 数据包头：基站主动发送0xB1;sdk主动发送0xD1 |
| 1-2 | defualt |  |
| 3-4 | com seq | 通信序号 |
| 5 | BASEID | 指定的基站编号，为0时候不指定 |
| 6 | DATA-type | 1：json数据 <br>2：普通数据;  |
| 7-10 | DATA_total| 数据总字节数  |
| 11-14 | total DATA crc32 | 总数据(DATA_total长度)crc32|
| 15 | transfer total | 总传输次数 |
| 16 | transfer cur | 当前传输次数 |
| 17-18 | This PACK Len |本次要传输的数据包长度  |
| 19-22 | This Pack crc32 | 本次要传输的数据(This PACK Len长度)crc32 |
|default  |   |  |
|60-63  | crc32  | 此数据包的crc32；从byte0-59共60个字节 |

举例：sdk要发送(1071 * 2 +512 bytes)数据给基站 
第一个发送单元：
    step1: 
        3-4：100 
        7-10 bytes： (1071 * 2 +512 bytes)
        11-14 ：数据总长度的crc
        15 : 3 
        16 : 0 
        17-18 : 1071 
        19-22 ：1071数据的crc       
        60-63 : crc
    step2: 基站ack
    step3: sdk发送1071长度数据；63byte * 17包；
    step4: sdk发送询问信息 
    step5: 基站ack

第二个发送单元：
    step1: 
        3-4：100 
        7-10 bytes： (1071 * 2 +512 bytes)
        11-14 ：数据总长度的crc
        15 : 3 
        16 : 1
        17-18 : 1071 
        19-22 ：1071数据的crc       
        60-63 : crc
    step2: 基站ack
    step3: sdk发送1071长度数据；63byte * 17包；
    step4: sdk发送询问信息 
    step5: 基站ack

第三个发送单元：
    step1: 
        3-4：100 
        7-10 bytes： (1071 * 2 +512 bytes)
        11-14 ：数据总长度的crc
        15 : 3 
        16 : 2
        17-18 : 512 
        19-22 ：512数据的crc       
        60-63 : crc        
    step2: 基站ack
    step3: sdk发送512长度数据；63byte * 9包；
    step4: sdk发送询问信息 
    step5: 基站ack

接收方应答：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 0 | Header | 数据包头：sdk应答0xB1;基站应答0xD1 |
| 1-2 | defualt |  |
| 3-4 | com seq | 通信序号 |
| 5 | BASEID | 指定的基站编号，为0时候不指定 |
| 6 | DATA-type | 1：json数据 <br>2：普通数据;  |
| 7-10 | DATA_total| 数据总字节数  |
| 11-14 | total DATA crc32 | 总数据crc32 |
| 15 | transfer total | 总传输次数 |
| 16 | transfer cur | 当前传输次数 |
| 17-18 | This PACK Len |本次要传输的数据包长度  |
| 19-22 | This Pack crc32 | 本次要传输的数据crc32 |

## 1.2 发送方连续发送N包数据包，接收方无需回复
每个数据包都带一个字节的数据头：
- 基站主动发送0xB2;下一字节表示当次传输序号从1开始 1-N
- sdk主动发送0xD2下一字节表示当次传输序号从1开始 1-N

## 1.3 发送方发送询问
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 0 | Header | 数据包头：基站主动发送0xB3;sdk主动发送0xD3 |
| 1-2 | defualt |  |
| 3-4 | com seq | 通信序号 |
| 5 | BASEID | 指定的基站编号，为0时候不指定 |
| 6 | DATA-type | 1：json数据 <br>2：普通数据;  |
| 7-10 | DATA_total| 数据总字节数  |
| 11-14 | total DATA crc32 | 总数据crc32 |
| 15 | transfer total | 总传输次数 |
| 16 | transfer cur | 当前传输次数 |
| 17-18 | This PACK Len |本次要传输的数据包长度 |
| 19-22 | This Pack crc32 | 本次要传输的数据crc32 |

接收方应答：
| **字节** | **标识符** | **描述** |
| --- | --- | --- |
| 0 | Header | 数据包头：基站主动发送0xB3;sdk主动发送0xD3 |
| 1-2 | defualt |  |
| 3-4 | com seq | 通信序号 |
| 5 | BASEID | 指定的基站编号，为0时候不指定 |
| 6 | DATA-type | 1：json数据 <br>2：普通数据;  |
| 7-10 | DATA_total| 数据总字节数  |
| 11-14 | total DATA crc32 | 总数据crc32 |
| 15 | transfer total | 总传输次数 |
| 16 | transfer cur | 当前传输次数 |
| 17-18 | This PACK Len |本次要传输的数据包长度  |
| 19-22 | This Pack crc32 | 本次要传输的数据crc32 |
| 23 | result | 接收方验证后回复结果：1-成功；2-失败 |
| 24-N | result_information | 接收到的包号，依次往下写。接收方判断result为失败的时候查看这里可以直接做补传，后续直接发送0XB2 or0XD2 补传对应包 再询问|



# 二， 功能协议

## 2.1 固件升级类协议

### 2.1.0 固件升级类的流程：
usbjson协议 固件升级类流程：完全沿用现有mqtt模式下的固件升级流程： 
- step1:上层软件发送固件升级指令
  - 升级对象(基站，键盘，字库...) 
  - 固件的url地址
  - 固件crc32 
  usbjson模式下，此处的url 无任何用处；
- step2: 基站获取文件长度
  - usbjson 模式下需要补充协议 
- 基站按需获取固件数据段 
  - usbjson模式下需要补充协议 
- 基站报告升级完成




### 2.1.1 usbjson固件升级补充协议


#### 2.1.1.1 sEvtReqeustFwData
- **功能描述**：申请固件文件数据段信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|baseSn|string||是|基站的出厂编码|
|data|object|-|是|传送参数的对象|
|+range_start|uint||是|数据段的起始
|+range_end|uint||是|数据段结束

- **示例代码**
```json
{
  "fun":"sEvtReqeustFwData",
  "dataTag":"1",
  "baseSn":"2024061101",
  "data":{
    "range_start":0,
    "range_end":5
  }
}
```


#### 2.1.1.2 fwDataInfo
- **功能描述**：发送指定数据段信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|baseSn|string||是|基站的出厂编码|
|data|object|-|是|传送参数的对象|
|+file_len|uint||是|固件文件总长度，指十进制字节个数
|+range_start|uint||是|数据段的起始
|+range_end|uint||是|数据段结束
|+fw_data|string||是|数据段,base64编码，减少数据长度
- **示例代码**
```json
{
  "fun":"fwDataInfo",
  "dataTag":"1",
  "baseSn":"2024061101",
  "data":{
    "file_len":15647,
    "range_start":0,
    "range_end":5,
    "fw_data": "bc1234ffff"
  }
}
```

## 2.2 基站心跳
### 2.2.1 sEvtHeartBeat
- **功能描述**：发送心跳
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|baseSn|string||是|基站的出厂编码|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站心跳周期，单位S,  SDK 以此时间\*1.5判断基站是否还在正常运行，基站以此时间\*1.5判断SDK是否还在正常运行
- **示例代码**
```json
{
    "fun":"sEvtHeartBeat",
    "dataTag":"1",
    "baseSn":"2024061101",
    "data":
    {
      "value":5
    }
}
```





# 三， **平台sdk与基站通讯加解密流程**

## 3.1 加密方式

加密算法是AES-256，公钥和私钥的长度都是32字节。

## 3.2 私钥生成、获取过程

1、sdk检测到基站连接，发送通过随机从100组公钥取出的1组公钥（如果获取的公钥是第1组，则通讯不加密，便于调试），加密发送的获取私钥的json数据（长度不大于64字节）。

{
    "fun":"getPK",
    "dataTag":"1"
}

2、基站收到加密的json数据，遍历从100组公钥取1组公钥来解密，如果能获取到基站连接参数josn数据，则认为接收的数据有效，退出遍历，返回通过解密成功的公钥，来加密含随机生成的私钥的json数据给sdk。私钥PK是通过Base64编码后的字符串。（长度不大于64字节）

{"PK":"345352522345sf23423423QER23TERT2341341232342134134"}

## 3.3 通讯加解密

要发送的单次数据，通过私钥加密后再发出。

接收到的单次数据，通过私钥解密后再处理。



